SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION dbo.CF_Clientes_UCP_xCbteEsp(@pId_Cliente INT)
RETURNS DATETIME
AS
BEGIN
DECLARE @UCP_Especial DATETIME

/*Se agrega un tipo de Cbte capaz de modificar la ltima cuota paga en caso de encontrase en estado Pendiente*/

SET @UCP_Especial = (SELECT ISNULL(MIN(CI.Fecha_QA), '19000101')
								FROM Cbtes_Items CI, Cbtes CB, Productos PR, Cbtes_Tipos CT
								WHERE
								CB.Id_Trans = CI.Id_Trans
								AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
								AND CI.Id_Producto = PR.Id_Producto
								AND CT.Compromete_Factura IN (1)
								AND CB.Id_Estado_Cbte IN (1/*Pendiente*/)
								AND PR.Id_Familia = (DBO.CF_xParam('Fam_CuotasSoc'))
								AND CI.Id_Cliente = @pId_Cliente
								AND CB.Id_Tipo_Cbte = (DBO.CF_xParam('TipoCbteModifUCP')))
								 
RETURN ISNULL(@UCP_Especial, '19000101')
END
